<?php
// ezWebAdmin
// Copyright (C) 2011 Michele Pinassi <michele.pinassi@unisi.it>
//
// This program is free software: you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation, either version 3 of the 
// License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
// even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
// General Public License for more details.
// You should have received a copy of the GNU General Public License along with this program. If not,
// see http://www.gnu.org/licenses/. 


include "header.php";

function isSelected($value,$ref) {
    if($value == $ref) {
		return "selected";
    }
}

if(session_is_registered("LOGGED")) {
    include "menu.php";
    $items = ezParser($ezConfigFile);
    $groups = array();
    if(count($items) > 0) {
        foreach($items as $item) {
	    	if($item->Type == "RES") {
				if(!in_array($item->Group,$groups)) {
				    array_push($groups,$item->Group);
				}
	    	}
		}
    }
    if($_POST["action"] == "delete") {
        $id = $_POST["ID"];
        $item =& $items[$id];
        $item->Type = "";
        if(ezSave($ezConfigFile,$items)) {
    		echo "<h2>Accesso rimosso con successo</h2>";
    		LogWrite("delete resource ".$item->Title);
			echo "<a href=index.php>Clicca qui per continuare</a>";
        } else {
			echo "<h2>Errore</h2>";
			echo "<a href=index.php>Clicca qui per continuare</a>";
		}
	} else if($_POST["action"] == "disable") {
	        $id = $_POST["ID"];
	        $item =& $items[$id];
        	$item->isEnable = false;
        	if(ezSave($ezConfigFile,$items)) {
		   		echo "<h2>Risorsa disabilitata con successo</h2>";
		   		LogWrite("disable resource ".$item->Title);
				echo "<a href=index.php>Clicca qui per continuare</a>";
			} else {
				echo "<h2>Errore</h2>";
				echo "<a href=index.php>Clicca qui per continuare</a>";
			}
    } else if($_POST["action"] == "enable") {
		    $id = $_POST["ID"];
		    $item =& $items[$id];
        	$item->isEnable = true;
        	if(ezSave($ezConfigFile,$items)) {
		   		echo "<h2>Risorsa abilitata successo</h2>";
		   		LogWrite("enable resource ".$item->Title);
				echo "<a href=index.php>Clicca qui per continuare</a>";
			} else {
				echo "<h2>Errore</h2>";
				echo "<a href=index.php>Clicca qui per continuare</a>";
			}

    } else if($_POST["action"] == "save") {
        $id = $_POST["ID"];
        $item =& $items[$id];
        $item->Title = $_POST["titolo"];
        $item->URL = $_POST["url"];
        $item->Commands = array();
        LogWrite("modified resource ".$item->Title);
        for($c=0;$c<100;$c++) {
	    	if(strlen($_POST["arg".$c]) > 0) {
    			if(strlen($_POST["com".$c]) > 0) {
		    		$item->addCommand($_POST["com".$c]." ".$_POST["arg".$c]);
				} else {
		    		$item->addCommand($_POST["arg".$c]);
		    	}
			}
		}
		if($_POST["isPublished"] == "on") {
			$item->isPublished = true;
		} else {
			$item->isPublished = false;
		}
		$item->addNote("Modified on ".date("j n Y")." by ".GetClientIP());
		if(ezSave($ezConfigFile,$items)) {
		    echo "<h2>OK, modifiche salvate</h2>";
		    echo "<a href=index.php>Clicca qui per continuare</a>";
		} else {
		    echo "<h2>Errore</h2>";
		    echo "<a href=index.php>Clicca qui per continuare</a>";
		}
    } else if($_POST["action"] == "create") {
        $item = new _cfgItem;
        $item->Type = "RES";
        $item->Title = $_POST["titolo"];
        $item->URL = $_POST["url"];
        LogWrite("created resource ".$item->Title);
	    $item->Commands = array();
	    for($c=0;$c<100;$c++) {
	    	if(strlen($_POST["arg".$c]) > 0) {
			   	if(strlen($_POST["com".$c]) > 0) {
					$item->addCommand($_POST["com".$c]." ".$_POST["arg".$c]);
		    	} else {
					$item->addCommand($_POST["arg".$c]);
		    	}
			}
		}
	    $item->Group = $_POST["group"];
	    if($_POST["isPublished"] == "on") {
	    	$item->isPublished = true;
	    } else {
			$item->isPublished = false;
	    }
	    $item->addNote("Created on ".date("j n Y")." by ".GetClientIP());
    	array_push($items,$item);
	    if(ezSave($ezConfigFile,$items)) {
	     	echo "<h2>Accesso creato con successo</h2>";
	     	echo "<a href=index.php>Clicca qui per continuare</a>";
	    } else {
	        echo "<h2>Errore</h2>";
	        echo "<a href=index.php>Clicca qui per continuare</a>";
	    }
    } else {
        $id = $_POST["ID"];
        echo "<div class=item><form method=POST>\n";
        if($_POST["action"] == "edit") {
    	    echo "<input type=hidden name=action value='save'>
	    <input type=hidden name=ID value='".$id."'>";
    	    $item = $items[$id];
	} else {
	    echo "<input type=hidden name=action value='create'>";
	    $item = new _cfgItem;
	}
	echo "
	Titolo della risorsa: <input type=text name=titolo value='".$item->Title."' class=testo><br>
	<blockquote class=tip>
		Inserire un nome per questa risorsa.
	</blockquote>
	Gruppo di accesso: <select name=group>";
	foreach($groups as $group) {
	    echo "<option value='$group' ".isSelected($group,$item->Group).">$group<br>";
	}
	echo "</select>
	<br>
	<blockquote class=tip>
	Il <i>gruppo di accesso</i> che pu usufruire di questa risorsa.
	</blockquote>
	URL della risorsa: <input type=text name=url value='".$item->URL."' class=testo><br>
	<blockquote class=tip>
		Specificare l'URL principale della risorsa: verr usato come identificativo da ezProxy.
	</blockquote>";
	$c=1;
	foreach($item->Commands as $line) {
	    list($command, $args) = split(' ', $line, 2);
	    echo "
	    <div class=cfgline>
		<select name=com$c onChange=\"setHint('help$c',this.options[this.selectedIndex].value)\">
		    <option value=''></option>
		    <option value='Domain' ".isSelected($command,'Domain').">Domain</option>
		    <option value='Host' ".isSelected($command,'Host').">Host</option>
		    <option value='DJ' ".isSelected($command,'DJ').">DJ</option>
		    <option value='HJ' ".isSelected($command,'HJ').">HJ</option>
		    <option value='Find' ".isSelected($command,'Find').">Find</option>
		    <option value='Replace' ".isSelected($command,'Replace').">Replace</option>
		</select>
	   	<input type=text name=arg$c value='".$args."' class=testo></div>
	   	<div class=hint id='help$c'></div>
	   	<div class=spacer>&nbsp;</div>";
		$c++;
	}
	for(;$c<15;$c++) {
	    echo "
		<div class=cfgline>
		<select name=com$c onChange=\"setHint('help$c',this.options[this.selectedIndex].value)\">
		    <option value=''></option>
		    <option value='Domain'>Domain</option>
		    <option value='Host'>Host</option>
		    <option value='DJ'>DJ</option>
		    <option value='HJ'>HJ</option>
		    <option value='Find'>Find</option>
		    <option value='Replace'>Replace</option>
		</select>
	   	<input type=text name=arg$c class=testo></div>
	   	<div class=hint id='help$c'>
	   	</div>
	   	<div class=spacer>&nbsp;</div>";
	}
	echo "
	    <blockquote class=tip>
    		ATTENZIONE: L'ordine di inserimento dei comandi rispecchia fedelmente il file di configurazione.
	    </blockquote>
	    Risorsa pubblicata:";
	if($item->isPublished) {
	    echo "<input type=checkbox name=isPublished checked>";
	} else {
	    echo "<input type=checkbox name=isPublished>";
	}
	echo "<br>
	    <blockquote class=tip>
	    	Spuntare questa casella se si desidera che la risorsa venga elencata nella pagina principale (non influisce sul funzionamento di ezProxy).
	    </blockquote>
	    <input type=submit value='Salva'></form>
	    </div>\n";
    }
} else {
    echo "<h2>Non sei abilitato all'uso di questo portale</h2>";
}
include "footer.php";
?>
