<?php
// ezWebAdmin
// Copyright (C) 2011 Michele Pinassi <michele.pinassi@unisi.it>
//
// This program is free software: you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation, either version 3 of the 
// License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
// even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
// General Public License for more details.
// You should have received a copy of the GNU General Public License along with this program. If not,
// see http://www.gnu.org/licenses/. 



/* ============================ EZPROXY PARSER ============================ */
class _cfgItem {
    var $ID;
    var $Type;
    var $Group;
    var $Title;
    var $Commands = array(); /* Comandi non riconosciuti */
    var $URL;
    var $Note = array();
    var $isPublished=false;
    var $isEnable=true;

    function addNote($noteString) {
		array_push($this->Note,$noteString);
    }
    function addCommand($commandString) {
		array_push($this->Commands,$commandString);
    }

}

function LogWrite($testo) {
	global $myLog;
	$handle = fopen($myLog, "a");
	if($handle == false) {
		return false;
	}
	$now = date("D M j G:i:s T Y");
	fwrite($handle,$now." - ".GetClientIP()." - ".$testo."\n");
	fclose($handle);
}

function ezTestUrl($URL) {
    global $ezproxyURL;
    return "http://$ezproxyURL:2048/login?url=".$URL;
}

function ezSave($file,$items) {
    global $ezBackupDir;
    LogWrite("backup configuration");
    // Fai backup
    $today = date("mdy-His");
    $bckfile = $ezBackupDir."\ezconfig_".$today.".cfg";
    if(!copy($file,$bckfile)) {
    	echo "<b>Backup file non riuscito !</b><br>";
    }
    // Salva
    if(count($items) > 0) {
	$handle = fopen($file, "w");
	if($handle == false) {
		return false;
	}
	if(fwrite($handle, "# edit by ezWebAdmin - Do not modify by hand !!!\n\n") == false) {
	    return false;
	}
    foreach($items as $item) {
	    if($item->Type == "RES") {

			if(strlen($item->Group) > 0) {
	    	    fwrite($handle,"\n\nGroup ".$item->Group."\n");
			} else {
        	    fwrite($handle,"\n\n");
			}
			if(!$item->isEnable) {
    			fwrite($handle,"Title ".$item->Title."\n");
				fwrite($handle,"#@DISABLED\n");
				fwrite($handle,"##URL ".$item->URL."\n");
				foreach($item->Commands as $other) {
				    fwrite($handle,"##".$other."\n");
				}
			} else {
    			fwrite($handle,"Title ".$item->Title."\n");
				fwrite($handle,"URL ".$item->URL."\n");
				foreach($item->Commands as $other) {
				    fwrite($handle,$other."\n");
				}
			}
			if($item->isPublished) {
			    fwrite($handle,"#@PUBLISHED\n");
			}
			foreach($item->Note as $note) {
			    fwrite($handle,"#!".$note."\n");
			}
	    } else if($item->Type == "HEAD") {
	        fwrite($handle,$item->Title."\n");
	    }
	}
    LogWrite("saved configuration");
	return true;
    }
    return false;
}

function ezParser($file) {
    $lines = file($file);

    $currGroup = "";
    $items = array();
    $item = false;
    $id = 0;
	$header = true;

    foreach($lines as $line_num => $line) {
		$line = trim($line);
		if((strlen($line) > 0) && ((($line[0] == '#')&&($line[1] == '#')) || ($line[0] != '#'))) {
			if(($line[0] == '#')&&($line[1] == '#')) {
				$line[0] = ' ';
				$line[1] = ' ';
				$line = trim($line);
			}
		    list($command, $args) = split(' ', $line, 2);
		    if(strcasecmp($command, "Group") == 0) {
				$currGroup = $args;
			} else if((strcasecmp($command, "Title") != 0)&&($header == true)) {
				if($item) {
				    array_push($items,$item);
				}
				$item = new _cfgItem;
				$item->ID = $id;
				$item->Type = "HEAD";
				$item->Title = $command." ".$args;
				$id++;
		    } else if(strcasecmp($command, "Title") == 0) {
		    	$header = false;
				if($item) {
				    array_push($items,$item);
				}
				$item = new _cfgItem;
				$item->ID = $id;
				$item->Type = "RES";
				$item->Title = $args;
				$item->Group = $currGroup;
				$id++;
		    } else if(strcasecmp($command, "URL") == 0) {
				$item->URL = $args;
		    } else {
		    	$item->addCommand($command." ".$args);
		    }
		} else {
		    // Comando speciale
		    if(strstr($line,"#!")) {
				list($dummy, $command) = split('!', $line, 2);
				if($item) {
				    array_push($item->Note,$command);
				}
		    }
		    // Impostazione
		    if(strstr($line,"#@")) {
		    	if(trim($line) == "#@PUBLISHED") {
		    		$item->isPublished = true;
		    	}
		    	if(trim($line) == "#@DISABLED") {
		    		$item->isEnable = false;
		    	}
		    }
		}
    }
    if($item) {
        array_push($items,$item);
    }
    return $items;
}

function StringSplit($s_Data) {
	if(strlen($s_Data) > 60) {
		$arr = str_split($s_Data,60);
		return $arr[0]."...[continue]";
	} else {
		return $s_Data;
	}
}

/* ============================== FUNCTIONS ================================ */

function CleanInput($u_Input) {
    /* Rimuovi tutti i caratteri NON alfanumerici (eccetto .,-_) */
    $banlist = array (
	" insert ", " select ", " update ", " delete ", " distinct ", " having ", " truncate ", " replace ",
	" handler ", " like ", " as ", " or ", " procedure ", " limit ", " order by ", " group by ", " asc ", " desc "
    );
    $replacelist = array (
	" ins3rt ", " s3lect ", " upd4te ", " d3lete ", " d1stinct ", " h4ving ", " trunc4te ", " r3place ",
	" h4ndler ", " l1ke ", " 4s ", " 0r ", " procedur3 ", " l1mit ", " 0rder by ", " gr0up by ", " 4sc ", " d3sc "
    );
    if(eregi( "[a-zA-Z0-9]+", $u_Input )) {
	$u_Input = trim(str_replace($banlist, $replacelist, $u_Input));
    } else {
	$u_Input = NULL;
    }
    return $u_Input;
}

// Ritorna l'IP del visitatore
function GetClientIP() {
    if(getenv('HTTP_X_FORWARDED_FOR')) {
	return getenv('HTTP_X_FORWARDED_FOR');
    } else {
	return getenv('REMOTE_ADDR');
    }
}


function APG() {
  $salt = "abchefghjkmnpqrstuvwxyz0123456789";
  srand((double)microtime()*1000000);
  	$i = 0;
  	while ($i <= 5) {
    		$num = rand() % 33;
    		$tmp = substr($salt, $num, 1);
    		$pass = $pass . $tmp;
    		$i++;
  	}
  	return $pass;
}

?>
